/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* Joystick functions */


//#define WIN32_LEAN_AND_MEAN
//#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <tchar.h>
#include <commctrl.h>
#include <stdio.h>
#include <math.h>

#include "mylistvw.h"
#include "../../cpc/joystick.h"
#include "resource.h"
#include "cpcemu.h"
#include "keystack.h"
#include "OnScreenDisplay.h"
#include "reg.h"
#include "joy.h"

static JoystickInternalData joysticks[MAX_JOYSTICKS];
JoystickConfigDataSystem joystickConfigs2[MAX_JOYSTICKS];

int change_index = 0; // currently changing which button?

//static BOOL			JoystickEnabled;

/* number of joysticks supported by device */
//static int			NoOfJoysticks;

/* joystick capabilities */
//static JOYCAPS JoystickCaps;

/* id of joystick to read */
//static int joystickID = JOYSTICKID1;

//static int	XPos, YPos, Buttons;
//static int XDead,YDead,XMid,YMid;

int PlayerJoy;
BOOL Joypad_Simuled;
int DeadZone = 2000; //Deadzone

void HandleDeadZone(JoystickInternalData *element)
{
	/*Analog to digital convertion using dead zone and Radial Dead Zone method*/

	/*Now calculating the radial value*/
	int ang;
	double rad = sqrt(pow((float)element->x.cur,2) + pow((float)element->y.cur,2));
	/*Now calculating the radial value*/
	double a = element->x.cur / rad;
	if (a < -1) a = -1;
	if (a > 1) a = 1;
	ang = (int)(180 / 3.14f * acos(a));
	/*Work only from 0 to 180, so need to correct values*/
	if (element->y.cur > 0) ang += (360 - 2 * ang);

	/* Reset values */
	element->x.cur = 0;
	element->y.cur = 0;

	/* ignore if in dead zone */
	if (rad < (DeadZone))
	{
		return;
	}

	/* check direction according to angle */
	/* 22 > 67 > 112 > 157 > 202 > 247 > 292 > 336 */
	if ((ang >= 112) && (ang <= 247)) element->x.cur = element->x.min;
	else if ((ang >= 292) || (ang <= 67)) element->x.cur = element->x.max;

	if ((ang >= 22) && (ang <= 157)) element->y.cur = element->y.min;
	else if ((ang >= 202) && (ang <= 336)) element->y.cur = element->y.max;

}

/* keypath to get to OEM destination (WinNT/Win98) */
const TCHAR *KeyPath[]=
{
	_T("System"),
	_T("CurrentControlSet"),
	_T("Control"),
	_T("MediaProperties"),
	_T("PrivateProperties"),
	_T("Joystick"),
	_T("OEM"),
	NULL
};

/* keypath to get to joystick key (Win98) */
const TCHAR *KeyPathWin9x[]=
{
	_T("System"),
	_T("CurrentControlSet"),
	_T("Control"),
	_T("MediaResources"),
	_T("joystick"),
	NULL
};


BOOL	KeyStack_ExecutePath(KeyStack *pStack, HKEY RootKey, TCHAR **pPath)
{
	HKEY CurrentKey;
	BOOL bSuccess = TRUE;
	HKEY ParentKey = RootKey;
	char **pPathPtr = pPath;

	/* attempt to open keys */
	while ((*pPathPtr)!=NULL)
	{
		/* attempt to open this key for reading */
		if (RegOpenKeyEx(ParentKey,(*pPathPtr), 0, KEY_READ, &CurrentKey)!=ERROR_SUCCESS)
		{
			/* failed */
			bSuccess = FALSE;
			break;
		}

		KeyStack_Push(pStack,CurrentKey);

		ParentKey = CurrentKey;
		pPathPtr++;
	}

	return bSuccess;
}

/******************************************************************************************/

BOOL	GetStringValue(HKEY Key, TCHAR *pValueName, TCHAR **ppValueData)
{
	DWORD BufferSize;
	DWORD Type;

	/* get size of data */
	if (RegQueryValueEx(Key, pValueName, 0, &Type, NULL, &BufferSize)==ERROR_SUCCESS)
	{
		/* string? */
		if ((Type==REG_SZ) && (BufferSize!=0))
		{
			char *pBuffer;

			/* allocate a buffer */
			pBuffer = (char *)malloc(BufferSize*sizeof(TCHAR));

			/* get value */
			if (RegQueryValueEx(Key, pValueName, 0, &Type, (LPBYTE)pBuffer, &BufferSize)==ERROR_SUCCESS)
			{
				*ppValueData= pBuffer;
				return TRUE;
			}
		}
	}

	return FALSE;
}
/******************************************************************************************/

BOOL GetJoystickName(int id,JOYCAPS *pJoystickCaps, char **ppName)
{
	BOOL bSuccess;
	KeyStack keyStack;

	KeyStack_Init(&keyStack);
	bSuccess = FALSE;

#if 1
	/* windows 98: manufacturer id and product id are returned for joystick driver and not joystick! */
	if ((pJoystickCaps->wMid == MM_MICROSOFT) && (pJoystickCaps->wPid == MM_PC_JOYSTICK))
	{
		if (KeyStack_ExecutePath(&keyStack, HKEY_LOCAL_MACHINE, (TCHAR **)KeyPathWin9x))
		{
			TCHAR *SubKeyPath[3];

			SubKeyPath[0] = pJoystickCaps->szRegKey;
			SubKeyPath[1] = _T("CurrentJoystickSettings");
			SubKeyPath[2] = NULL;

			if (KeyStack_ExecutePath(&keyStack, KeyStack_GetTopItem(&keyStack), (TCHAR **)SubKeyPath))
			{
				TCHAR *pOEMName;
				TCHAR ValueName[32];

				_stprintf(ValueName,_T("Joystick%dOEMName"),id+1);

				if (GetStringValue(KeyStack_GetTopItem(&keyStack), ValueName, &pOEMName))
				{
					KeyStack_Close(&keyStack);

					/* got oem name */
					if (KeyStack_ExecutePath(&keyStack, HKEY_LOCAL_MACHINE, (TCHAR **)KeyPath))
					{
						if (KeyStack_OpenKey(&keyStack, KEY_READ,pOEMName))
						{
							/* get value */
							if (GetStringValue(KeyStack_GetTopItem(&keyStack), _T("OEMName"), ppName))
							{
								bSuccess = TRUE;
							}
						}
					}

					free(pOEMName);
				}
			}
		}
	}
	else
	{
		TCHAR VID_PID_RegKeyName[18];

		/* generate the vendor id/product id key */
		_stprintf(VID_PID_RegKeyName,"VID_%04x&PID_%04x",pJoystickCaps->wMid, pJoystickCaps->wPid);

		if (KeyStack_ExecutePath(&keyStack, HKEY_LOCAL_MACHINE, (TCHAR **)KeyPath))
		{
			if (KeyStack_OpenKey(&keyStack, KEY_READ,VID_PID_RegKeyName))
			{
				/* get value */
				if (GetStringValue(KeyStack_GetTopItem(&keyStack), _T("OEMName"), ppName))
				{
					bSuccess = TRUE;
				}
			}
		}
	}

	KeyStack_Close(&keyStack);
#endif
	return bSuccess;
}

void JoystickConfiguration_SetupListView(HWND hListView)
{
	int NumJoysticks;
	int i;

	SendMessage(hListView, WM_SETREDRAW, (WPARAM)FALSE, (LPARAM)0);

	/* delete all existing items */
	ListView_DeleteAllItems(hListView);

	/* add columns */
	MyListView_AddColumn(hListView, _T("ID"),0);
	MyListView_AddColumn(hListView, _T("Name"),1);

	/* get number of devices that are supported */
	NumJoysticks = joyGetNumDevs();

	for (i=0; i<NumJoysticks; i++)
	{
		int Count;
		MMRESULT	hResult;
		JOYCAPS JoystickCaps;
		char IDText[32];

		Count = ListView_GetItemCount(hListView);

		sprintf(IDText,"%d",i+1);

		/* add column 0 data */
		MyListView_AddItem(hListView,IDText,0,Count, (void *)i);

		/* add column 1 data */
		hResult = joyGetDevCaps(i, &JoystickCaps, sizeof(JoystickCaps));

		if (hResult==JOYERR_NOERROR)
		{
			char *name;

			if (GetJoystickName(i,&JoystickCaps,&name))
			{
				MyListView_AddItem(hListView, name,1,Count,NULL);

				free(name);
			}
			else
			{
				char JoystickName[32];

				sprintf(JoystickName,"Joystick #%d",i);

				MyListView_AddItem(hListView, JoystickName,1,Count,NULL);
			}
		}
		else
		{
			/* (none) */
			MyListView_AddItem(hListView, _T("(none)"),1,Count, NULL);
		}
	}
	SendMessage(hListView, WM_SETREDRAW, (WPARAM)TRUE, (LPARAM)0);
	InvalidateRect(hListView,NULL, FALSE);

}

int GetJoystickIDByName(char * NomJoy)
{
	int NumJoysticks;
	int i;
	int ID;
	char tmp[255];

	NumJoysticks = joyGetNumDevs();

	for (i=0; i<NumJoysticks; i++)
	{
		//int Count;
		MMRESULT	hResult;
		JOYCAPS JoystickCaps;

		ID = i;

		hResult = joyGetDevCaps(i, &JoystickCaps, sizeof(JoystickCaps));

		if (hResult==JOYERR_NOERROR)
		{
			char *name;
			if (GetJoystickName(i,&JoystickCaps,&name))
			{
				strncpy(tmp,name,strlen(name));
				tmp[strlen(name)]='\0';
				free(name);
			}
			else
			{
//				char JoystickName[32];
				sprintf(tmp,"Joystick #%d",i);
			}
		}
		else
		{
			sprintf(tmp,"(none)",i);
		}

		if (strcmp(NomJoy,tmp) == 0) return ID;

	}

	return -1;
}

BOOL CALLBACK JoystickConfiguration_DialogProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    switch (iMsg)
    {

		case WM_INITDIALOG:
		{
			HWND hList = GetDlgItem(hwnd, IDC_LIST_JOY);
			//char tmp2[255];

			if (PlayerJoy == 2)
			{
					SetWindowText(hwnd,"CPC Joystick Player 2");
					//MyApp_Registry_GetString("JOYSTICK","Name_2", tmp2);
			}
			else
			{
				//MyApp_Registry_GetString("JOYSTICK","Name_1", tmp2);
			}

			if (hList)
			{
				UINT State;

				ListView_SetExtendedListViewStyle(hList, LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
				JoystickConfiguration_SetupListView(hList);
				State = ListView_GetItemState(hList, joystickConfigs2[PlayerJoy - 1].realJoystickData.id, LVIS_SELECTED);
				State|=LVIS_SELECTED;
				ListView_SetItemState(hList, joystickConfigs2[PlayerJoy - 1].realJoystickData.id, LVIS_SELECTED,State);

			
			}
		}
		return TRUE;


        case WM_CREATE:
            return TRUE;

			//EndDialog(hwnd,0);

        case WM_COMMAND:
        {
			switch LOWORD(wParam)
	        {
				case IDOK:
				{
					LV_ITEM itemInfo;
					char tmp[255];
					char tmp2[255];
					int j;
					HWND hList = GetDlgItem(hwnd, IDC_LIST_JOY);
					int index = ListView_GetNextItem(hList, -1, LVIS_SELECTED);
					
					itemInfo.iItem = index;
					itemInfo.iSubItem = 0;
					itemInfo.mask = LVIF_TEXT;
					itemInfo.cchTextMax = 256;
					itemInfo.pszText = tmp;
					//ListView_GetItem(hList, &itemInfo);
					//index = atoi(tmp);
					itemInfo.iSubItem = 1;
					ListView_GetItem(hList, &itemInfo);
					if (!strcmp(tmp,"(none)") == 0)
					{
						j = PlayerJoy - 1;
						if (j < 0) j = 0;
						//joystickConfigs2[j].Type = JOYSTICK_TYPE_REAL;
						//joystickConfigs2[j].realJoystickData.id = index;

						sprintf(tmp2,"Joystick for player %d initialised : %s",PlayerJoy,tmp);
						SetInfoMessage(tmp2);

						sprintf(tmp2,"Name_%d",PlayerJoy);
						MyApp_Registry_SetString("JOYSTICK",tmp2, tmp);

					}
					else
					{
						j = PlayerJoy - 1;
						if (j < 0) j = 0;
						//joystickConfigs2[j].Type = JOYSTICK_TYPE_UNKNOWN;
						//joystickConfigs2[j].realJoystickData.id = index;
						//joystickConfigs2[j].Active = FALSE;

						sprintf(tmp2,"Joystick for player %d initialised : %s",PlayerJoy,tmp);
						SetInfoMessage(tmp2);

						sprintf(tmp2,"Name_%d",PlayerJoy);
						MyApp_Registry_SetString("JOYSTICK",tmp2, tmp);
					}

					Joystick_Init();

					EndDialog(hwnd, 0);
					return TRUE;
					
				}
				break;

				case IDCANCEL:
					{
						EndDialog(hwnd, -1);
					}
					return TRUE;


				default:
					break;

			}
		}
		break;

		case WM_CLOSE:

			break;
		case WM_DESTROY:
			break;

/*    case WM_DESTROY:
		PostQuitMessage (0);
		return TRUE;
*/
	}
    return FALSE;
}

void JoystickConfigurationDialog(HWND hwnd,int player)
{
	HINSTANCE hInstance = (HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE);
	PlayerJoy = player;
	DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG_JOYSTICK),hwnd,JoystickConfiguration_DialogProc);
}


/* read joystick */
BOOL Joystick_Read(int RealID, int id , JoyInfoSystem *joy)
{
	MMRESULT	hResult;
	JOYCAPS JoystickCaps;

	if (RealID == -1 ) return FALSE;

	hResult = joyGetDevCaps(RealID, &JoystickCaps, sizeof(JoystickCaps));

	if (hResult==JOYERR_NOERROR)
	{
		JOYINFOEX JoystickInfo;
		DWORD Xmid;
		DWORD Ymid;

		JoystickInfo.dwSize = sizeof(JOYINFOEX);
		JoystickInfo.dwFlags = JOY_RETURNALL;

		Xmid = ((JoystickCaps.wXmax-JoystickCaps.wXmin)>>1) + JoystickCaps.wXmin;
		Ymid = ((JoystickCaps.wYmax-JoystickCaps.wYmin)>>1) + JoystickCaps.wYmin;

		joysticks[id].x.min = JoystickCaps.wXmin - Xmid;
		joysticks[id].x.max = JoystickCaps.wXmax - Xmid;
		joysticks[id].y.min = JoystickCaps.wYmin - Ymid;
		joysticks[id].y.max = JoystickCaps.wYmax - Ymid;


		hResult = joyGetPosEx(RealID, &JoystickInfo);

		if (JoystickInfo.dwButtons != 0)
		{
			int ggg = 8;
		}


		if (hResult==JOYERR_NOERROR)
		{

			joysticks[id].x.cur = JoystickInfo.dwXpos-Xmid;
			joysticks[id].y.cur = JoystickInfo.dwYpos-Ymid;

			HandleDeadZone(&joysticks[id]);
			joysticks[id].buttons = JoystickInfo.dwButtons;

			joy->x = joysticks[id].x.cur;
			joy->y = joysticks[id].y.cur;
			joy->buttons = joysticks[id].buttons;

		}
	}
	else
		return FALSE;
	return TRUE;
}

void JoyConvertion(int id,JoyInfoSystem *j)
{
	int i;
	int ButtonMask = -1;
	for (i=0; i < 8; i++)
	{
		if (j->buttons == joystickConfigs2[id].Button[i]) ButtonMask = i;
	}

	j->buttons = ButtonMask;
}

int GetIDPhysical(int ID)
{
	return joystickConfigs2[ID].realJoystickData.id;
}

void Joystick_Init()
{

//	int NumJoysticks;
	int joystickID;
	int index = 0;
	int i;
	int j;
	char tmp[255];
	char tmp2[255];

	//JoystickEnabled = FALSE;

	Joypad_Simuled = FALSE;

	for (i=0; i < 2; i++)
	{
		
		sprintf(tmp,"Name_%d",i+1);
		MyApp_Registry_GetString("JOYSTICK",tmp, tmp2);

		joystickID = GetJoystickIDByName(tmp2);

		if (strcmp(tmp2,"(none)") == 0)
		{
			joystickID = -1;
		}

		if ( joystickID != -1 ) {
			Joystick_Activate(i,TRUE);
			Joystick_SetType(i,JOYSTICK_TYPE_REAL);
			Joystick_SetPhysical(i,joystickID);
		}
		else
		{
			if (Joypad_Simuled)
			{	
				Joystick_Activate(i,TRUE);
				Joystick_SetType(i,JOYSTICK_TYPE_SIMULATED_BY_KEYBOARD);
				joystickConfigs2[i].realJoystickData.id = -1;
				Joystick_SetPhysical(i,-1);
			}
			else
			{
				Joystick_Activate(i,FALSE);
				Joystick_SetType(i,JOYSTICK_TYPE_UNKNOWN);
				joystickConfigs2[i].realJoystickData.id = -1;
				Joystick_SetPhysical(i,-1);
			}
		}
		
		for (j=0; j < (2 + 5 *(1-i)); j++)
		{
			sprintf(tmp,"BUTTON_%d[%d]",i+1,j);
			MyApp_Registry_GetString("JOYSTICK",tmp, tmp2);
			joystickConfigs2[i].Button[j] = atoi(tmp2);
		}



#if 0
		HRESULT hResult;
		JOYINFOEX JoystickInfo;
		JOYCAPS JoystickCaps;

		/* select joystick 1 */
		joystickID = JOYSTICKID1;


		/* is joystick attached */
		hResult = joyGetPosEx(joystickID, &JoystickInfo);

		if (hResult != MMSYSERR_NODRIVER)
		{
			/* driver available */

			hResult = joyGetDevCaps(joystickID, &JoystickCaps, sizeof(JoystickCaps));

			if (hResult == JOYERR_NOERROR)
			{
				XMid = (JoystickCaps.wXmax-JoystickCaps.wXmin)>>1;
				YMid = (JoystickCaps.wYmax-JoystickCaps.wYmin)>>1;
				XDead = 2000;
				YDead = 2000;

				JoystickEnabled = TRUE;
			}
		}
#endif
	}

	//Get dead zone
	DeadZone = MyApp_Registry_GetValue("JOYSTICK","DeadZone");
	if (DeadZone < 4000) DeadZone = 4000;
	if (DeadZone > 32000) DeadZone = 32000;

	//	JoystickEnabled = TRUE;

}


//************************************************************************************************************
//dialog definition control

int check_change_joypadX(int index,int joy) 
{
	/*
   if(di_joystick_c[joy] == NULL)
      return 0;

   HRESULT hRes; 
   DIJOYSTATE js; 
 
   hRes = IDirectInputDevice7_Poll(di_joystick_c[joy]);

   hRes = IDirectInputDevice7_GetDeviceState(di_joystick_c[joy], sizeof(DIJOYSTATE), &js); 

   if(hRes != DI_OK) 
   { 
      di_joystick_c[joy]->Acquire();
      return 0;
   } 

   for(int i=0;i<10;++i)
   {
      if(js.rgbButtons[i] & 0x80) 
      { 
         options->joystick_config[joy][index] = i;
         return 1;
      }    
   }    
   */
   return 0;                   
}

static int oldbutton;
int check_change_joypad(int change_index,int joy)
{
	JoyInfoSystem joyInfo;
	int a;
	if (Joystick_Read(joystickConfigs2[joy].realJoystickData.id, joy, &joyInfo))
	{
		//joyData.x = joyInfo.x;
		//joyData.y = joyInfo.y;
		a = joyInfo.buttons;
	}
	else return -1;

	if (a != oldbutton)
	{
		return a;
	}
 
   return -1;
}

VOID CALLBACK TJoyProc(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime)
{  
   char tmp[20];
   int joy = 0;
   char buffer[10];
   int changed;

   GetDlgItemText(hwnd, ID_CTRLJOY_TEXT, tmp,20);
   if (strcmp(tmp,"Joueur : 2") == 0) { joy = 1; }
   
   changed = check_change_joypad(change_index,joy);
   
   if (changed == -1) return;
      
   sprintf(buffer,"%d",changed);
   joystickConfigs2[joy].Button[change_index] = changed;
   SetDlgItemText(hwnd, IDC_CTRLJOY_1+change_index, buffer); 
} 

BOOL CALLBACK ControlJoy_Dialog_Proc(HWND hDialog, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	int i,j;
	char buffer[10];
	char tmp[255];
	char tmp2[255];
	int joy = -1;

	GetDlgItemText(hDialog, ID_CTRLJOY_TEXT, tmp,20);//hwnd to verif
    if (strcmp(tmp,"Joueur : 2") == 0) { joy = 1; }
	if (strcmp(tmp,"Joueur : 1") == 0) { joy = 0; }

    switch(iMsg) 
    { 
    case WM_INITDIALOG:
       for(i=0;i<(2 + 5 *(1-joy));++i)
       {
           HWND hwndx = GetDlgItem(hDialog, IDC_CTRLJOY_1+i);
           SendMessage(hwndx, EM_SETREADONLY, TRUE,0L);
          
           sprintf(buffer,"%d",joystickConfigs2[joy].Button[i]);
           SetDlgItemText(hDialog, IDC_CTRLJOY_1+i, buffer); 
       }  
       change_index = 0;
       
       timer_id = SetTimer(hDialog,20,100,TJoyProc);
    break;
    case WM_COMMAND: 
            if(HIWORD(wParam) == EN_SETFOCUS && LOWORD(wParam) >= IDC_CTRLJOY_1 && LOWORD(wParam) <= IDC_CTRLJOY_EXIT)
            {
			   HWND hwndx;
               change_index = LOWORD(wParam)-IDC_CTRLJOY_1;
			   hwndx = GetDlgItem(hDialog,LOWORD(wParam));
			   GetDlgItemText(hwndx, IDC_CTRLJOY_1+change_index, buffer,sizeof(buffer)); 
			   oldbutton = atoi(buffer);
               break;
            }
               
            switch (LOWORD(wParam)) 
            { 
			case IDOK:
				if (joy == -1) break;
				//save new config
				for (j=0; j < (2 + 5 *(1-joy)); j++)
				{
					sprintf(tmp,"BUTTON_%d[%d]",joy+1,j);
					sprintf(tmp2,"%d",joystickConfigs2[joy].Button[j]);
					MyApp_Registry_SetString("JOYSTICK",tmp, tmp2);
				}
                KillTimer(hDialog,timer_id);           
                EndDialog(hDialog, wParam);

                return TRUE; 
                
            case IDCANCEL:              
                KillTimer(hDialog,timer_id);                    
                EndDialog(hDialog, wParam); 
                return TRUE; 
            } 
    break;
    } 
    return FALSE; 
}

void ControlJoyDialog(HWND hParent,int joueur)
{
	//HWND hDialog;
	HINSTANCE hInstance = (HINSTANCE)GetWindowLong(hParent, GWL_HINSTANCE);

	//hDialog = CreateDialog (hInstance, MAKEINTRESOURCE(IDD_DIALOG_CTRLJOY), 0, ControlJoy_Dialog_Proc);
	//ShowWindow(hDialog,TRUE);

	//DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG_CTRLJOY),hParent,ControlJoy_Dialog_Proc);

	if (joueur == 0) { DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG_CTRLJOY1),hParent,ControlJoy_Dialog_Proc); }
	else { DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG_CTRLJOY2),hParent,ControlJoy_Dialog_Proc); }
                
 //   Init_DI_change_joy(hDialog,joueur);
}
